Attribute VB_Name = "mdlAlgo1"
Option Explicit

Private Const M_PI As Single = 3.14159265359
Private Const M_ATN As Single = 1.5707963267949 '//2 * Atn(1)

Private Declare Function SetPixel Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long
Public Declare Function GetPixel Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long) As Long

Public src() As Long

Public myPallette(256) As Long

Private Function acos(Num As Double) As Double
    On Error Resume Next
    acos = Atn(-Num / Sqr(-Num * Num + 1)) + M_ATN
End Function

Public Sub MakeGlobal(Optional sngAngle As Integer = 20, Optional lngWidth As Long = 256, Optional lngHeight As Long = 256)
    Dim Y As Long, X As Long, W As Long
    Dim Offs As Single
    Dim dstW As Long, dstH As Long
    Dim dst() As Long ', 'src() As Long
    Dim sngDestH As Single, sngDestW As Single
    Dim fx As Single, fy As Single, tx As Single, ty As Single
    Dim alpha As Double
    Dim q As Double
  
    Offs = (sngAngle * lngWidth) / 360
    dstH = lngHeight
    dstW = lngWidth
      
    sngDestH = dstH / 2
    sngDestW = dstW / 2

 
    For Y = 1 To dstH - 1 Step 1
        q = 1 * Abs(sngDestH - Y) / sngDestH
        W = sngDestW * Sqr(1 - q * q)
        
        For X = -W To W - 1 Step 1
            ty = Y
            tx = sngDestW + X
            fy = Y
            alpha = acos((X) / W) / M_PI
            
            fx = Int((Offs + alpha * sngDestW + 1 * lngWidth) Mod lngWidth)
            'Call SetPixel(frmMain.Picture1.hdc, tx, ty, src(fx, fy))
            Call SetPixel(frmMain.Picture1.hdc, tx, ty, myPallette(src((fx * lngHeight) + fy)))
        
        Next X
    Next Y

End Sub
