Attribute VB_Name = "mdlICQExtract"
Option Explicit

'//By Almar Joling, www.persistentrealities.com
'//Made for ICQ database backupping

'//Nothing was reverse engineered whatsoever form to make this module
'//Nor has Mirabilis or ICQ have anything to do with it.

'//This module was made to backup ICQ history, just in case anything goes wrong
'//and not to rely on the ICQ database format. At ICQ lots of things happened that
'//Are important in my life, and will be forever. If I lost the history I would
'//probably regret that my entire life.

'//Almar
'//reply@persistentrealities.com


Public Type IDX_HDR
    num1 As Long
    num2 As Long
    num3 As Long
    Root As Long
    version As Long
    num4 As Long
    num5 As Long
    num6 As Long
    num7 As Long
    num8 As Long
    num9 As Long
    num10 As Long
    num11 As Long
    num12 As Long
    num13 As Long
    numZ(0 To 9) As Long
    num0(0 To 124) As Byte
End Type

Public Type IDX_ENTRY
    Entry_Status As Long
    Entry_Number As Long
    Next_Entry As Long
    Prev_Entry As Long
    DAT_Entry As Long
End Type

Public Type DAT_HDR
    Data_Group As Long
    Data_Number As Long
    Data_Type(15) As Byte
End Type

Public Type MESSAGES
    Seperator As Integer
    flags As Long
    EntryType As Integer
    UIN As Long
    MessLEN As Integer
End Type

Public MessBody() As Byte
Public Mess As String

Public Type MessageFooter
    X As Long
    Y As Long
    z As Integer
    TimeStamp As Long
End Type

Public Type DAT_PACK
    H As DAT_HDR
    'Data_Spec(0 To 9999) As Byte
    M As MESSAGES
End Type

Public fin As Long
Public fda As Long
Public buf As IDX_ENTRY
Public D As DAT_PACK
Public Pack_Size As Long
Public Flag As Boolean
Public Footer As MessageFooter


Public myTime As String

Private Type ByteArray
    myBytes() As Byte
End Type

Public GroupNames As Variant

Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)


Private Type myFileUDT
    UIN As Long
    strBuffer As String
    Nick As String
End Type
Public myFileData() As myFileUDT

Public blnContactList As Boolean

Private Type udtItem
    strKeyWord As String
    strValue As String
End Type
Public ContactItems() As udtItem

Public Type udtContact
    ContactInfo() As udtItem
    UIN As Long
End Type
Public ContactList() As udtContact

Public blnContactListFetched As Boolean


'Public Function TimeStamp2Str(SecsSince1970 As Double) As String
'    Const SecsPerDay As Long = 60& * 60& * 24&
'    Dim s1970 As Long, sTmp As Long, sDate As Long
'    Dim D As Long
'
'    TimeStamp2Str = DateAdd("s", SecsSince1970, #1/1/1970#)
'End Function

Public Sub OpenFile(strDBFile As String)
    fin = FreeFile
    Open strDBFile & ".idx" For Binary As fin
    
    fda = FreeFile
    Open strDBFile & ".dat" For Binary As fda
        
End Sub


Public Sub Reset()
    '//This one is correct now!
    Dim Root As Long

    Seek fin, 13
    Get #fin, , Root
    Call ReadEntry(Root)
    
End Sub
Public Sub ReadEntry(offset As Long)
     '//Add 1 to every offset..
     Seek fin, (offset + 1)
     Get #fin, , buf

     ShowEntry
End Sub


Public Sub ShowEntry()
    Dim X As IDX_ENTRY
    Dim strText As String
    
    With frmMain.Text1
        strText = ""
        strText = "IDXPos : --- " & Loc(fin) - Len(X) & " ---" & vbCrLf
        strText = strText & "Status: " & buf.Entry_Status & vbCrLf
        strText = strText & "Number: " & buf.Entry_Number & vbCrLf
        strText = strText & "Next: " & buf.Next_Entry & vbCrLf
        strText = strText & "Previous: " & buf.Prev_Entry & vbCrLf
        strText = strText & "DAT: " & buf.DAT_Entry & vbCrLf
        .Text = strText
    End With
    
    '//Read dat
    If buf.Entry_Status = -2 And buf.DAT_Entry <> -1 Then Call ReadDatEntry(buf.DAT_Entry)
End Sub

Public Sub ReadDatEntry(offset As Long)
    Dim Fact As Integer, i As Integer
    Dim sTmp As String ', Mess As String
    Dim Time As Long
    Dim myArray As ByteArray
    Dim ArraySize As Long
    Dim strTemp As String
    Dim strResult As String
    
    '//For Wave list
    Dim myLong1 As Long, myLong2 As Long, myLong3 As Long
    Dim WaveEntries As Long
    Dim intWaves As Integer

    Dim lngWaveEventID As Long
    Dim lngUseUserWave As Long, intLengthFile As Integer
    Dim strWaveFile() As Byte
    Dim bByteSig As Byte, intSeperator As Integer
    '\\
    
    '//Add 1 to every offset..
    Seek fda, (offset + 1)
    Get #fda, , Pack_Size

    'If (Pack_Size >= Len(D)) Or (Pack_Size < 0) Then
    If (Pack_Size < 0) Then
        Exit Sub
    End If
    
    Get #fda, , D.H
           
    ArraySize = 0
    
    If D.H.Data_Group = 1 Then
        '//*****Contact list*******************

        Seek fda, (Loc(fda)) '+ 3
        Get #fda, , bByteSig
        Get #fda, , intSeperator
        Get #fda, , myLong1 '    1431520594 "USER"
        Get #fda, , myLong2      '//user status
        Get #fda, , myLong3      '//group
        Get #fda, , intSeperator  '//sep
        Get #fda, , WaveEntries  '//#waventries
    
        '//Get the custom wave entries
        If WaveEntries > 0 Then
            '//Get Wave entries
            For intWaves = 1 To WaveEntries
                Get #fda, , intSeperator
                Get #fda, , lngWaveEventID
                Get #fda, , lngUseUserWave
                Get #fda, , intLengthFile
                ReDim strWaveFile(1 To intLengthFile)
                Get #fda, , strWaveFile
                strResult = Space$(intLengthFile)
                
                CopyMemory ByVal strResult, strWaveFile(1), UBound(strWaveFile) - 1
            Next
        End If

        Get #fda, , intSeperator    '//Seperator

        '//Get user properties now
        Dim intUserSeperator As Integer, lngNumUserProperties As Long
        Dim intDatEntry As Long
        Dim intByteSig As Byte
        ReDim MessBody(1 To 38)
        Dim lngUserProperties As Long

        Get #fda, , lngUserProperties   '//Amount of user properties

'
        
        
        '//Now follows an list of all user properties...
        Dim lngProperty As Long                     '//Loop count
        Dim strPropertyName As String               '//Propery name
        Dim bPropertySize As Byte                   '//Property size
        Dim z As Long
        Dim lngProps As Long
        Dim intStringLength As Integer
        Dim blnEscape As Boolean

        '//Create a temp contact list..
        Dim ThisContact As udtContact
        Dim lngArrayCount As Long
        Dim lngUIN As Long
        ThisContact.ContactInfo = ContactItems
        
        
                For z = 1 To lngUserProperties
                    Get #fda, , intSeperator
                    
                    '//Erorr!
                    If intSeperator < 0 Or intSeperator > 1000 Then
                        Stop
                        Exit For
                    End If
                    
                    Get #fda, , lngProps
                    
                    blnEscape = False
                    
                    Dim Y As Long
                    For lngProperty = 1 To lngProps
                        Get #fda, , intStringLength  '//Get length of keyword
                        
                        If intStringLength > 40 Then
                            blnEscape = True
                            Exit For
                        End If
                        
                        strPropertyName = Space$(intStringLength)
                        Get #fda, , strPropertyName
                        Get #fda, , bPropertySize
                        strPropertyName = Replace$(strPropertyName, Chr$(0), vbNullString)
                        strResult = ReturnField(bPropertySize)
                        
                        '//Store uin!
                        If strPropertyName = "UIN" Then lngUIN = strResult
                        
                        '//Now we will loop through all items in the list
                        With ThisContact
                            For Y = 1 To UBound(.ContactInfo)
                                '//Does it match?
                                If StrComp(.ContactInfo(Y).strKeyWord, strPropertyName, vbTextCompare) = 0 Then
                                    '//Yes.. so store our value!
                                    .ContactInfo(Y).strValue = strResult
                                    
                                    '//And exit our loop
                                    Exit For
                                End If
                            Next Y
                        
                        End With
                    

                    Next
                    
                    If blnEscape = True Then Exit For
                

                Next
                
                If blnEscape = False Then
                
                    '//Add this contact to our contact list
                    lngArrayCount = UBound(ContactList) + 1
                    ReDim Preserve ContactList(lngArrayCount)
                    
                    '//Store the info
                    ContactList(lngArrayCount).ContactInfo = ThisContact.ContactInfo
                    ContactList(lngArrayCount).UIN = lngUIN
                End If
                
    Else
        '//Get message.. this is not contact list
        Get #fda, , D.M
    End If
    
    '//Do not continue, we only want contacts (speed things up)
    If blnContactList = True Then Exit Sub
    
   If D.M.MessLEN > 0 Then
        If D.M.MessLEN > 9000 Then Exit Sub
        ArraySize = D.M.MessLEN
        ReDim MessBody(1 To D.M.MessLEN)
        Get #fda, , MessBody
        Get #fda, , Footer
        
        Mess = Space$(UBound(MessBody) + 1)
        CopyMemory ByVal Mess, MessBody(1), UBound(MessBody) - 1
        Mess = Mid$(Mess, 1, D.M.MessLEN)
    End If
    
    
    If ((Len(D) + ArraySize + Len(Footer)) < Pack_Size) And ArraySize > 0 Then
        If Pack_Size < 9000 Then
            Dim myNewTest() As Byte
            Dim lngPos As Long
            Dim lngPosEnd As Long
            
            If Footer.z = 547 Then
                ReDim myNewTest(1 To (Pack_Size - (Len(D) + ArraySize + Len(Footer))))
                Seek #fda, Loc(fda) + 19
                Dim Test1 As Integer
                Get #fda, , Test1
                Get #fda, , myNewTest
               
                strTemp = Space$(UBound(myNewTest) + 1)
                CopyMemory ByVal strTemp, myNewTest(1), UBound(myNewTest) - 1


                lngPos = InStr(1, strTemp, "{\rtf1", vbTextCompare)
                If lngPos > 0 Then lngPosEnd = InStr(1, strTemp, "\par" & vbCrLf & "}", vbTextCompare)
                If lngPosEnd > 0 Then
                    strTemp = Mid$(strTemp, lngPos, ((lngPosEnd - lngPos) + Len("\par" & vbCrLf & "}")))
                    Mess = strTemp

                End If
            End If
        End If
    End If

    Dim strText As String
    With frmMain.Text2
        strText = "Dat Position: --- " & Hex(offset) & " ---" & vbCrLf
        strText = strText & "Data_Spec_Size:  " & Pack_Size & vbCrLf
        
        Dim strGroup As String
        If D.H.Data_Group < 12 And D.H.Data_Group > -2 Then
            strGroup = GroupNames(D.H.Data_Group)
        Else
            strGroup = "?"
        End If
        '//Show position info...
        strText = strText & "Data_Group: " & D.H.Data_Group & " (" & strGroup & ")" & vbCrLf
        strText = strText & "Data number: " & D.H.Data_Number & vbCrLf
        strText = strText & "Data type: " & CStr(D.H.Data_Type) & vbCrLf
        .Text = strText
    End With
    
    If D.H.Data_Group <> -1 Then
        If ((D.H.Data_Group = 0) Or (D.H.Data_Group = 9) Or (D.H.Data_Group = 5)) Then
            sTmp = ""
            '//Message type
            Select Case D.M.EntryType
                Case 1:   sTmp = "       Message "
                Case 2:   sTmp = "  Chat Request "
                Case 4:   sTmp = "           URL "
                Case 6:   sTmp = "  Contacts ??? "
                Case 9:   sTmp = " System Message "
                Case 13:  sTmp = "  Contact List "
            End Select

            '//Public var!
            myTime = DateAdd("s", Footer.TimeStamp, #1/1/1970#)
            
            
            If (D.M.flags And 1) = 1 Then
               sTmp = "From: " & D.M.UIN & " " & myTime
            Else
               sTmp = "To: " & D.M.UIN & " " & myTime
            End If
            
            Mess = Replace$(Mess, Chr$(0), "")

            '//Get rid of RTF tags.. cheap way, but it works
            If InStr(1, Mess, "{\rtf1", vbTextCompare) > 0 Then
                frmMain.txtHistory.TextRTF = Mess
                Mess = frmMain.txtHistory.Text
            End If
       End If

    End If
End Sub

Public Function ReturnField(bPropertySize As Byte) As Variant
    Dim caseChar As String * 1, caseByte As Byte, caseWord As Integer, caseInteger As Integer
    Dim caseDWORD As Long, caseLONG As Long, caseWORDString As Integer, bFieldValue() As Byte
        
    Select Case bPropertySize
        Case 100
            Get #fda, , caseChar
            ReturnField = Asc(caseChar)
        
        Case 101
            Get #fda, , caseByte                        '//Get byte value
            ReturnField = caseByte
        
        Case 102
            Get #fda, , caseWord
            ReturnField = caseWord
            
        Case 103
            Get #fda, , caseInteger
            ReturnField = caseInteger
        
        Case 104
            Get #fda, , caseDWORD
            ReturnField = caseDWORD
            
        Case 105
            Get #fda, , caseLONG
            ReturnField = caseLONG
        
        Case 107
            Get #fda, , caseWORDString                  '//Get length of string
            ReDim bFieldValue(1 To caseWORDString)      '//Redim our array to that size
            
            Get #fda, , bFieldValue
            
            Dim myString As String
            myString = Space$(UBound(bFieldValue) + 1)
            CopyMemory ByVal myString, bFieldValue(1), UBound(bFieldValue) - 1
            ReturnField = myString
    End Select
End Function
