#pragma once
#include "main include file.h"
#include <vector>


typedef struct _D3DXKEY_QUATERNION
{
    FLOAT Time;
    D3DXQUATERNION Value;
} D3DXKEY_QUATERNION, *LPD3DXKEY_QUATERNION;

typedef struct _D3DXKEY_VECTOR3 {
    FLOAT Time;
    D3DXVECTOR3 Value;
} D3DXKEY_VECTOR3, *LPD3DXKEY_VECTOR3;



typedef struct
{
	D3DXVECTOR3 p;
	D3DXVECTOR3 n;
	D3DXVECTOR2 uv;
} D3DVertex_t;
#define D3DFVF_VERTEX (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1)

typedef struct
{
	D3DMATERIAL8 mat;
	LPDIRECT3DTEXTURE8 pTexture;
	BOOL bSphereMap;
	FLOAT fTransparency;
} D3DShader_t;

typedef struct
{
	INT nParentBone;
	D3DXMATRIX matObject;
	D3DXMATRIX matObjectAnim;
	D3DXMATRIX matWorld;
	D3DXMATRIX matWorldInv;
	D3DXMATRIX matWorldAnim;
	
	//Animation purposes
	D3DXKEY_QUATERNION* RotationKeys;
	DWORD NumRotationKeys;
	D3DXKEY_VECTOR3* TranslationKeys;
	DWORD NumTranslationKeys;

	//LPD3DXKEYFRAMEINTERPOLATOR pInterpolator;
} D3DBone_t;

class CMS3DFile;
class CD3DSkinnedMesh
{
public:
	CD3DSkinnedMesh();
	virtual ~CD3DSkinnedMesh();

public:
	HRESULT CreateFromMS3DFile(LPDIRECT3DDEVICE8 pDevice, CMS3DFile *pMS3DFile, LPCTSTR lpszModelPath);
	HRESULT UpdateVertexBuffer();
	VOID ComputeBoundingSphere(D3DXVECTOR3 *pCenter, FLOAT *pRadius);
	HRESULT Destroy();
	void GetVectorAt(int nIndex, D3DXVECTOR3 **ppVector);
	DWORD GetNumSubsets();
	HRESULT SetSubsetShader(DWORD dwSubset);
	HRESULT DrawSubset(DWORD dwSubset);

	HRESULT Draw();
	HRESULT DrawEdges();
	HRESULT DrawBones();

	VOID SetFlatNormals(BOOL bEnable);
	BOOL HasFlatNormals();
	
	VOID SetDefaultShaderOnly(BOOL bEnable);
	BOOL HasDefaultShaderOnly();

	VOID SetTime(FLOAT fTime);
	FLOAT GetTime();
	FLOAT GetLowestTime();
	FLOAT GetAnimationFPS();
	FLOAT GetTotalFrames();
	VOID SetupBones();
	CMS3DFile *m_pMS3DFile;
private:

	LPDIRECT3DDEVICE8 m_pDevice;
	std::vector<D3DVertex_t> m_arrVertices;
	std::vector<int> m_arrVertexBoneIds;
	std::vector<D3DVertex_t> m_arrRenderVertices;
	std::vector<D3DXVECTOR3> m_arrFlatNormals;
	LPDIRECT3DVERTEXBUFFER8 m_pVertexBuffer;
	LPDIRECT3DVERTEXBUFFER8 m_pEdgeBuffer;
	LPDIRECT3DVERTEXBUFFER8 m_pBoneBuffer;
	std::vector<D3DXATTRIBUTERANGE> m_arrSubsets;
	std::vector<D3DShader_t> m_arrShaders;
	D3DShader_t m_shaderDefault;
	std::vector<D3DBone_t> m_arrBones;

	BOOL m_bHasFlatNormals;
	BOOL m_bDefaultShaderOnly;

	FLOAT m_fTime;
	FLOAT m_fLowestTime;
	FLOAT m_fTotalFrames;
private:
	CD3DSkinnedMesh(const CD3DSkinnedMesh& rhs);
	CD3DSkinnedMesh& operator=(const CD3DSkinnedMesh& rhs);
};
