#pragma once

#include "main include file.h"
#include <vector>

#ifndef byte
typedef unsigned char byte;
#endif // byte

#ifndef word
typedef unsigned short word;
#endif // word

#if defined( _MSC_VER ) || defined( __BORLANDC__ )
#	include <pshpack1.h>
#	define PACK_STRUCT
#	define PATH_MAX _MAX_PATH
#elif defined( __GNUC__ )
#	define PACK_STRUCT	__attribute__((packed))
#	include <limits.h>
#else
#	error you must byte-align these structures with the appropriate compiler directives
#endif

struct ms3d_header_t
{
    char    id[10];                                     // always "MS3D000000"
    int     version;                                    // 4
} PACK_STRUCT;

struct ms3d_vertex_t
{
    byte    flags;                                      // SELECTED | SELECTED2 | HIDDEN
    float   vertex[3];                                  //
    char    boneId;                                     // -1 = no bone
    byte    referenceCount;
} PACK_STRUCT;

struct ms3d_triangle_t
{
    word    flags;                                      // SELECTED | SELECTED2 | HIDDEN
    word    vertexIndices[3];                           //
    float   vertexNormals[3][3];                        //
    float   s[3];                                       //
    float   t[3];                                       //
    byte    smoothingGroup;                             // 1 - 32
    byte    groupIndex;                                 //
} PACK_STRUCT;

struct ms3d_edge_t
{
	word edgeIndices[2];
} PACK_STRUCT;

struct ms3d_group_t
{
    byte            flags;                              // SELECTED | HIDDEN
    char            name[32];                           //
    word            numtriangles;                       //
	std::vector<word> triangleIndices;					// the groups group the triangles
    char            materialIndex;                      // -1 = no material
} ;

struct ms3d_material_t
{
    char            name[32];                           //
    float           ambient[4];                         //
    float           diffuse[4];                         //
    float           specular[4];                        //
    float           emissive[4];                        //
    float           shininess;                          // 0.0f - 128.0f
    float           transparency;                       // 0.0f - 1.0f
    char            mode;                               // 0, 1, 2 is unused now
    char            texture[128];                        // texture.bmp
    char            alphamap[128];                       // alpha.bmp
} ;

struct ms3d_keyframe_rot_t
{
    float           time;                               // time in seconds
    float           rotation[3];                        // x, y, z angles
} PACK_STRUCT;

struct ms3d_keyframe_pos_t
{
    float           time;                               // time in seconds
    float           position[3];                        // local position
} PACK_STRUCT;

typedef struct
{
    byte            flags;                              // SELECTED | DIRTY
    char            name[32];                           //
    char            parentName[32];                     //
    float           rotation[3];                        // local reference matrix
    float           position[3];

    word            numKeyFramesRot;                    //
    word            numKeyFramesTrans;                  //

	std::vector<ms3d_keyframe_rot_t> keyFramesRot;      // local animation matrices
    std::vector<ms3d_keyframe_pos_t> keyFramesTrans;  // local animation matrices
} ms3d_joint_t;

#include <poppack.h>

class CMS3DFile
{
public:
	CMS3DFile();
	virtual ~CMS3DFile();

public:
	BOOL LoadFromFile(LPCTSTR lpszFileName);
	void Clear();

	DWORD GetNumVertices();
	void GetVertexAt(int nIndex, ms3d_vertex_t **ppVertex);
	DWORD GetNumTriangles();
	void GetTriangleAt(int nIndex, ms3d_triangle_t **ppTriangle);
	DWORD GetNumEdges();
	void GetEdgeAt(int nIndex, ms3d_edge_t **ppEdge);
	DWORD GetNumGroups();
	void GetGroupAt(int nIndex, ms3d_group_t **ppGroup);
	DWORD GetNumMaterials();
	void GetMaterialAt(int nIndex, ms3d_material_t **ppMaterial);
	DWORD GetNumJoints();
	void GetJointAt(int nIndex, ms3d_joint_t **ppJoint);
	int FindJointByName(LPCTSTR lpszName);
	


	float GetAnimationFPS();
	float GetCurrentTime();
	int GetTotalFrames();


private:

	std::vector<ms3d_vertex_t> m_arrVertices;
	std::vector<ms3d_triangle_t> m_arrTriangles;
	std::vector<ms3d_edge_t> m_arrEdges;
	std::vector<ms3d_group_t> m_arrGroups;
	std::vector<ms3d_material_t> m_arrMaterials;
	float m_fAnimationFPS;
	float m_fCurrentTime;
	int m_iTotalFrames;
	std::vector<ms3d_joint_t> m_arrJoints;

private:
	CMS3DFile(const CMS3DFile& rhs);
	CMS3DFile& operator=(const CMS3DFile& rhs);
};