Attribute VB_Name = "mdlAlwaysdebug"
Option Explicit

Private Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As Currency) As Long
Private Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As Currency) As Long

Private curFreq As Currency
Private curStart As Currency
Private curEnd As Currency

Private dblResult1 As Double
Private dblResult2 As Double
Private dblControl As Double
Private dblCompare As Double

Private Const lngIterations As Long = 500000
Private dblCompareStats(1 To 5) As Double
Private dblResult1Stats(1 To 5) As Double
Private dblResult2Stats(1 To 5) As Double

Public Sub Main()
    Dim I As Long
    Dim Y As Long
    '//Get Frequency
    QueryPerformanceFrequency curFreq
    
    '//Run all the test 5 times!
    For Y = 1 To 5
        '//Test1
        QueryPerformanceCounter curStart '//Start time
        For I = 1 To lngIterations '//Run test
            TestOne
        Next I
        QueryPerformanceCounter curEnd '//End Time
        dblResult1 = (curEnd - curStart) / curFreq  '//Calculate the duration of the test (in seconds)
        '\\End Test1
        
        '//Test2
        QueryPerformanceCounter curStart '//Start time
        For I = 1 To lngIterations '//Run test
            TestTwo
        Next I
        QueryPerformanceCounter curEnd '//End Time
        dblResult2 = (curEnd - curStart) / curFreq  '//Calculate the duration of the test (in seconds)
        '\\End Test2
        
       
        '//Calculate the end result
        dblCompare = (dblResult1 - dblControl) / (dblResult2 - dblControl) * 100
        '//Get the real %
        dblCompare = dblCompare - 100
        '//Save stats
        dblCompareStats(Y) = Round(dblCompare, 1)
        dblResult1Stats(Y) = Round(dblResult1, 6)
        dblResult2Stats(Y) = Round(dblResult2, 6)
    Next Y
    
    '//Save results to file
    Dim lngFreeFile As Long
    lngFreeFile = FreeFile
    Open App.Path & "\" & "Result.txt" For Output As #lngFreeFile
        Print #lngFreeFile, "% faster " & dblCompareStats(1) & "|" & dblCompareStats(2) & "|" & dblCompareStats(3) & "|" & dblCompareStats(4) & "|" & dblCompareStats(5)
        Print #lngFreeFile, "Test1|" & dblResult1Stats(1) & "|" & dblResult1Stats(2) & "|" & dblResult1Stats(3) & "|" & dblResult1Stats(4) & "|" & dblResult1Stats(5)
        Print #lngFreeFile, "Test2|" & dblResult2Stats(1) & "|" & dblResult2Stats(2) & "|" & dblResult2Stats(3) & "|" & dblResult2Stats(4) & "|" & dblResult2Stats(5)
    Close #lngFreeFile
    
    End
End Sub

Public Sub TestOne()
    'Empty
End Sub

Public Sub TestTwo()
    'Empty
End Sub
